unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls,
  UConsts, USG;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    imgKONIEC: TImage;
    sg: TStringGrid;
    procedure sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure FormShow(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);

  private

  public
    procedure  Koniec();
	 procedure  Przypisz_lp();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);

   ActiveControl := sg;
end;

procedure TMainForm.Przypisz_lp();
var
	ACol : Integer;
	ARow : Integer;

begin
	ACol := 0;
	ARow := 0;

	for ARow := 1 to sg.RowCount-1 do
   begin
		sg.Cells[ACol, ARow] := IntToStr(ARow);
	end;

	sg.Invalidate();
end;

procedure TMainForm.sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
var
	oldKolor   : TColor;
	inny_kolor : Boolean;
	txt        : String;
	x          : Integer;
	y          : Integer;
	fileName   : String;
	bmp        : TBitmap;

begin
	inny_kolor := false;
	txt        := '';
	x          := 0;
	y          := 0;

	if (ARow = 0) or( ACol = 0) then
	begin
		exit;
	end;

	// co drugi rzd w innym kolorze
	inny_kolor := (ARow mod 2) = 0;

	if inny_kolor then
	begin
		// if(!State.Contains(gdFocused))
		if not (gdFocused in State) then
		begin
			txt := sg.Cells[ACol, ARow];

			oldKolor := sg.Canvas.Brush.Color;
			// kolor niestandardowy
			// sg.Canvas.Brush.Color := TColor(0x00D6EAEF);
			sg.Canvas.Brush.Color := TColor($00D6EAEF);


			sg.Canvas.FillRect(Rect);

			x := Rect.Left + 2;
			y := (Rect.Top + Rect.Bottom - sg.Canvas.TextHeight(txt)) div 2;
			sg.Canvas.TextOut(x, y, txt);
			sg.Canvas.Brush.Color := oldKolor;
		end;
	end;

	if (ACol = colKodp) or (ARow = 4) then
	begin
		sg.Canvas.Brush.Color := clYellow;
		sg.Canvas.Pen.Color   := clYellow;
		sg.Canvas.FillRect(Rect);
		sg.Canvas.TextOut(Rect.Left+2, Rect.Top+2, sg.Cells[ACol, ARow]);
	end;

	if ACol = colImie then
	begin
		oldKolor := sg.Canvas.Font.Color;

		txt := Trim(sg.Cells[ACol, ARow]);

		if txt = 'Barbara' then
		begin
			sg.Canvas.Font.Color := clBlue;
			// sg.Canvas.Font.Style := TFontStyles() << fsBold;
			sg.Canvas.TextOut(Rect.Left+2, Rect.Top+2, sg.Cells[ACol, ARow]);
			txt := '';
		end;
		sg.Canvas.Font.Color := oldKolor;
	end;


	if ACol = colNazwisko then
	begin
		txt := Trim(sg.Cells[ACol, ARow]);
		if txt = 'Kowalski' then
		begin
			fileName := ExtractFilePath(Application.ExeName) + 'arrow.bmp';

			bmp := TBitmap.Create();
			if FileExists(fileName) then
			begin
				bmp.LoadFromFile(fileName);
			end;

			// draw the image
			try
			   if (gdFocused in State) then
				begin
					Rect.Left   := Rect.Left   + 70;
					Rect.Right  := Rect.Right  - 2;
					Rect.Top    := Rect.Top    + 2;
					Rect.Bottom := Rect.Bottom - 2;
				end
				else begin
					Rect.Left   := Rect.Left   + 70;
				end;

				// rozcignij BMP na ca ramk przeznaczon na obrazek
				sg.Canvas.StretchDraw(Rect, bmp);
         finally
         	FreeAndNil(bmp);
			end;
		end;
	end;
end;

end.

